USE TVPTests
GO
ALTER DATABASE [TVPTests] ADD FILEGROUP [TVPTest_MemObj] CONTAINS MEMORY_OPTIMIZED_DATA 
GO
USE TVPTests
GO
ALTER DATABASE TVPTests
 ADD FILE (name='TVPTest_MemObj1', filename='e:\sqldata\iTVPTest_MemObj1') TO FILEGROUP [TVPTest_MemObj]  
GO
DROP PROCEDURE IF EXISTS dbo.CheckFillDates
GO
DROP TYPE IF EXISTS PharmacyData;
GO
CREATE TYPE PharmacyData 
AS TABLE
(	
	Dosage INT,
	Drug VARCHAR(20),
	FirstName VARCHAR(50),
	LastName VARCHAR(50),
	AddressLine1 VARCHAR(250),
	PhoneNumber VARCHAR(50),
	CellNumber VARCHAR(50),
	EmailAddress VARCHAR(100),
	FillDate DATETIME,
PRIMARY KEY NONCLUSTERED 
(
	FirstName ASC,
	LastName ASC
)
)WITH ( MEMORY_OPTIMIZED = ON )
GO

GO
CREATE PROCEDURE dbo.CheckFillDates
(@Data [dbo].[PharmacyData] READONLY)
AS 
BEGIN 
DECLARE @FilteredResult [dbo].[PharmacyData]
INSERT INTO @FilteredResult
SELECT *
FROM @Data

IF (
SELECT COUNT(*) 
FROM @FilteredResult) < (SELECT COUNT(*) 
FROM @Data)
BEGIN
	SELECT *
	FROM @FilteredResult
END 
ELSE 
	SELECT *
	FROM @FilteredResult 
	UNION SELECT * 
	FROM @Data
END
GO

